<?php
/**
 * Theme hooks.
 *
 * @package HealthRehub
 */


// Menu description.
add_filter( 'walker_nav_menu_start_el', 'healthrehub_nav_menu_description', 10, 4 );

// Sidebars classes.
add_filter( 'healthrehub_widget_area_classes', 'healthrehub_set_sidebar_classes', 10, 2 );

// Add row to footer area classes.
add_filter( 'healthrehub_widget_area_classes', 'healthrehub_add_footer_widgets_wrapper_classes', 10, 2 );

// Set footer columns.
add_filter( 'dynamic_sidebar_params', 'healthrehub_get_footer_widget_layout' );

// Adapt default image post format classes to current theme.
add_filter( 'cherry_post_formats_image_css_model', 'healthrehub_add_image_format_classes', 10, 2 );

// Enqueue sticky menu if required.
add_filter( 'healthrehub_theme_script_depends', 'healthrehub_enqueue_misc' );

// Add has/no thumbnail classes for posts.
add_filter( 'post_class', 'healthrehub_post_thumb_classes' );

// Modify a comment form.
add_filter( 'comment_form_defaults', 'healthrehub_modify_comment_form' );

// Additional body classes.
add_filter( 'body_class', 'healthrehub_extra_body_classes' );

// Render macros in text widgets.
add_filter( 'widget_text', 'healthrehub_render_widget_macros' );

// Adds the meta viewport to the header.
add_action( 'wp_head', 'healthrehub_meta_viewport', 0 );

// Customization for `Tag Cloud` widget.
add_filter( 'widget_tag_cloud_args', 'healthrehub_customize_tag_cloud' );

// Changed excerpt more string.
add_filter( 'excerpt_more', 'healthrehub_excerpt_more' );

// tm-builder-modules-grid
add_filter( 'tm_builder_front_styles', 'healthrehub_builder_styles' );

// Adds custom icons.
add_filter( 'tm_builder_custom_font_icons', 'healthrehub_add_custom_font_icons' );

// Adds custom tmpl for services mosule.
add_filter( 'cherry_services_listing_templates_list', 'healthrehub_services_listing_templates_list' );

// Adds more button for team listings.
add_filter( 'cherry_team_data_callbacks', 'healthrehub_read_more_macros_func' );

// Adds custom font set for team members.
add_filter( 'cherry_team_members_meta_args', 'healthrehub_team_members_meta_args' );

// Change icon format for team members.
add_filter( 'cherry_team_social_icon_format', 'healthrehub_team_social_icon_format' );

// Adds custom macros for cherry team.
add_filter( 'cherry_team_data_callbacks', 'healthrehub_team_extra_macros_func', 10, 2 );

// Adds templates for team module
add_filter( 'cherry_team_templates_list', 'healthrehub_team_templates_list' );

// Adds custom macros for cherry services.
add_filter( 'cherry_services_data_callbacks', 'healthrehub_services_data_callbacks' );

// Custom gallery grid sizes
add_action('init', 'healthrehub_add_imeges_size_filter');


/**
 * healthrehub_add_imeges_size_filter
 */
function healthrehub_add_imeges_size_filter() {
	add_filter( 'tm_pg_get_sizes', 'healthrehub_images_sizes' );
}

/**
 * healthrehub_images_sizes
 *
 * @param  $args   The arguments
 *
 * @return   ( description_of_the_return_value )
 */
function healthrehub_images_sizes( $args ) {
	$args['grid-default'] = array(
		'width'   => '534',
		'height'  => '404',
		'type'   => 'grid',
	);
	return $args;
}

/**
 * Adds img url macros to services.
 * @param $array
 * @return $array
 */
function healthrehub_services_data_callbacks( $array ) {
	$array['img_url'] = 'healthrehub_service_image_url';
	return $array;
}

/**
 * service_image_url
 * @return $imgurl
 */
function healthrehub_service_image_url() {
	global $post;
	$imgurl = sprintf(
		'%s',
		get_the_post_thumbnail_url( $post->ID, 'healthrehub-thumb-l' )
	);
	return $imgurl;
}

/**
 * Adds templates for team module
 *
 * @return args
 */
function healthrehub_team_templates_list( $args ) {
	$args['with_more'] = 'with_more.tmpl';
	return $args;
}

/**
 * Change icon format for team members.
 * @return string
 */
function healthrehub_team_social_icon_format() {
	$icon_format = '<i class="team-socials_icon fl-glypho %s"></i>';
	return $icon_format;
}

/**
* Adds custom font set for team members.
* @param $args
* @return $args
*/
function healthrehub_team_members_meta_args( $args ) {
	$args['fields']['cherry-team-fax'] = array(
		'type'        => 'text',
		'placeholder' => esc_html__( 'Fax', 'healthrehub' ),
		'label'       => esc_html__( 'Fax', 'healthrehub' ),
	);
	$args['fields']['cherry-team-email'] = array(
		'type'        => 'text',
		'placeholder' => esc_html__( 'Enter email', 'healthrehub' ),
		'label'       => esc_html__( 'Email (wrong email entry will not be published)', 'healthrehub' ),
	);
	$args['fields']['cherry-team-social']['fields']['icon'] = array(
		'type'        => 'iconpicker',
		'id'          => 'icon',
		'name'        => 'icon',
		'label'       => esc_html__( 'Choose icon', 'healthrehub' ),
		'icon_data'   => array(
			'icon_set'    => 'hlyph',
			'icon_css'    => get_stylesheet_directory_uri() . '/assets/css/fl-glypho.css',
			'icon_base'   => false,
			'icon_prefix' => 'fl-glypho-',
			'icons'       => array(
				"armchair4",
				"behance13",
				"bell70",
				"briefcase69",
				"camera119",
				"camera120",
				"chart55",
				"chat118",
				"checkbox6",
				"chronometer",
				"clipboard",
				"coffee128",
				"directional-sign10",
				"document6",
				"downloading",
				"dribbble",
				"eye127",
				"facebook2",
				"flag97",
				"flask",
				"folded-map",
				"globe35",
				"google-plus",
				"happy-mac",
				"heart-rate",
				"hearts34",
				"house180",
				"inbox39",
				"inbox40",
				"instagram19",
				"jar21",
				"laptop130",
				"layers",
				"light-bulb4",
				"lightning31",
				"linkedin",
				"microphone3",
				"notebook91",
				"nut4",
				"pin66",
				"plug",
				"power5",
				"present33",
				"presentation22",
				"purse10",
				"pyre",
				"quaver3",
				"rocket77",
				"screen84",
				"share46",
				"shopping-cart7",
				"speech-bubble20",
				"star207",
				"switch33",
				"telephone120",
				"timer42",
				"truck69",
				"tumblr1",
				"twitter",
				"umbrella1",
				"uploading2",
				"user7",
				"video-player"
			),
		),
	);
	return $args;
}

/**
 * healthrehub_team_macros_func
 *
 * @param  $array
 * @return $array
 */
function healthrehub_team_extra_macros_func( $array ) {
	$array['fax'] = 'healthrehub_team_fax_macros';
	$array['email'] = 'healthrehub_team_email_macros';
	return $array;
}

/**
 * team_fax_macros
 *
 * @return $fax
 */
function healthrehub_team_fax_macros() {
	global $post;
	$fax = get_post_meta( $post->ID, 'cherry-team-fax', true );
	if ( ! empty( $fax ) ) {
		$fax = sprintf(
			'<div class="team-macros"><span class="team-meta_item fa-fax">%s</span></div>',
			$fax
		);
		return $fax;
	}
}

/**
 * team_email_macros
 *
 * @return  $email
 */
function healthrehub_team_email_macros() {
	global $post;
	$email = get_post_meta( $post->ID, 'cherry-team-email', true );
	if ( ! empty( $email ) ) {
		$email = sprintf(
			'<div class="team-macros"><span class="team-meta_item email"><a href="mailto:%1$s">%1$s</a></span></div>',
			sanitize_email( $email )
		);
		return $email;
	}
}

/**
 * Adds more button for team listings.
 * @param $array
 * @return $array
 */
function healthrehub_read_more_macros_func( $array ) {
	$array['more'] = 'healthrehub_team_more_link_button';
	return $array;
}

/**
 * team_more_link_button
 * @return $button
 */
function healthrehub_team_more_link_button() {
	global $post;
	$button = sprintf(
		'<a href="%s" class="btn btn-primary" >%s</a>',
		get_permalink( $post->ID ),
		esc_html__( 'Read more', 'healthrehub' )
	);
	return $button;
}

/**
 * Adds custom tmpl for services module.
 * @param $args
 * @return $args
 */
function healthrehub_services_listing_templates_list( $args ) {
	$args['listed-services'] = 'listed-services.tmpl';
    return $args;
}

/**
 * Adds custom icons.
 * @param $icons
 * @return $icons
 */
function healthrehub_add_custom_font_icons( $icons ) {
    $icons['material-design'] = array(
        'src'  => get_stylesheet_directory_uri() . '/assets/css/material-design.css',
        'base' => 'material-design',
    );
    $icons['fl-glypho'] = array(
        'src'  => get_stylesheet_directory_uri() . '/assets/css/fl-glypho.css',
        'base' => 'fl-glypho',
    );
    $icons['fontello'] = array(
        'src'  => get_stylesheet_directory_uri() . '/assets/css/fontello.css',
        'base' => 'fontello',
    );
    return $icons;
}

/**
 * Modify a breadcrumbs args
 * @param $args
 * @return mixed
 */
function healthrehub_builder_styles($style) {
	unset($style['tm-builder-modules-grid']);
	return $style;
}

/**
 * Append description into nav items
 *
 * @param  string  $item_output The menu item output.
 * @param  WP_Post $item        Menu item object.
 * @param  int     $depth       Depth of the menu.
 * @param  array   $args        wp_nav_menu() arguments.
 * @return string
 */
function healthrehub_nav_menu_description( $item_output, $item, $depth, $args ) {

	if ( 'main' !== $args->theme_location || ! $item->description ) {
		return $item_output;
	}

	$descr_enabled = get_theme_mod(
		'header_menu_attributes',
		healthrehub_theme()->customizer->get_default( 'header_menu_attributes' )
	);

	if ( ! $descr_enabled ) {
		return $item_output;
	}

	$current     = $args->link_after . '</a>';
	$description = '<div class="menu-item__desc">' . $item->description . '</div>';
	$item_output = str_replace( $current, $description . $current, $item_output );

	return $item_output;
}

/**
 * Set layout classes for sidebars.
 *
 * @since  1.0.0
 * @uses   healthrehub_get_layout_classes.
 * @param  array  $classes Additional classes.
 * @param  string $area_id Sidebar ID.
 * @return array
 */
function healthrehub_set_sidebar_classes( $classes, $area_id ) {

	if ( 'sidebar' !== $area_id ) {
		return $classes;
	}

	return healthrehub_get_layout_classes( 'sidebar', $classes );
}

/**
 * Set layout classes for sidebars.
 *
 * @since  1.0.0
 * @param  array  $classes Additional classes.
 * @param  string $area_id Sidebar ID.
 * @return array
 */
function healthrehub_add_footer_widgets_wrapper_classes( $classes, $area_id ) {

	if ( 'footer-area' !== $area_id ) {
		return $classes;
	}

	$classes[] = 'row';

	return $classes;
}


/**
 * Get footer widgets layout class
 *
 * @since  1.0.0
 * @param  string $params Existing widget classes.
 * @return string
 */
function healthrehub_get_footer_widget_layout( $params ) {

	if ( is_admin() ) {
		return $params;
	}

	if ( empty( $params[0]['id'] ) || 'footer-area' !== $params[0]['id'] ) {
		return $params;
	}

	if ( empty( $params[0]['before_widget'] ) ) {
		return $params;
	}

	$columns = get_theme_mod(
		'footer_widget_columns',
		healthrehub_theme()->customizer->get_default( 'footer_widget_columns' )
	);

	$columns = intval( $columns );
	$classes = 'class="col-xs-12 col-sm-%2$s col-md-%1$s %3$s ';

	switch ( $columns ) {
		case 4:
			$md_col = 6;
			$sm_col = 6;
			$extra  = 'col-lg-3';
			break;

		case 3:
			$md_col = 4;
			$sm_col = 4;
			$extra  = '';
			break;

		case 2:
			$md_col = 6;
			$sm_col = 6;
			$extra  = '';
			break;

		default:
			$md_col = 12;
			$sm_col = 12;
			$extra  = 'footer-area--centered';
			break;
	}

	$params[0]['before_widget'] = str_replace(
		'class="',
		sprintf( $classes, $md_col, $sm_col, $extra ),
		$params[0]['before_widget']
	);

	return $params;
}

/**
 * Filter image CSS model
 *
 * @param  array $css_model Default CSS model.
 * @param  array $args      Post formats module arguments.
 * @return array
 */
function healthrehub_add_image_format_classes( $css_model, $args ) {
	$css_model['link'] .= ' post-thumbnail--fullwidth';

	return $css_model;
}

/**
 * Add jQuery Stickup to theme script dependencies if required.
 *
 * @param  array $depends Default dependencies.
 * @return array
 */
function healthrehub_enqueue_misc( $depends ) {
	$header_menu_sticky = get_theme_mod( 'header_menu_sticky', healthrehub_theme()->customizer->get_default( 'header_menu_sticky' ) );

	if ( $header_menu_sticky && ! wp_is_mobile() ) {
		$depends[] = 'jquery-stickup';
	}

	$totop_visibility = get_theme_mod( 'totop_visibility', healthrehub_theme()->customizer->get_default( 'totop_visibility' ) );

	if ( $totop_visibility ) {
		$depends[] = 'jquery-totop';
	}

	return $depends;
}

/**
 * Add has/no thumbnail classes for posts
 *
 * @param  array $classes Existing classes.
 * @return array
 */
function healthrehub_post_thumb_classes( $classes ) {
	$thumb = 'no-thumb';

	if ( has_post_thumbnail() ) {
		$thumb = 'has-thumb';
	}

	$classes[] = $thumb;

	return $classes;
}

/**
 * Add placeholder attributes for comment form fields.
 *
 * @param  array $args Argumnts for comment form.
 * @return array
 */
function healthrehub_modify_comment_form( $args ) {
	$args = wp_parse_args( $args );

	if ( ! isset( $args['format'] ) ) {
		$args['format'] = current_theme_supports( 'html5', 'comment-form' ) ? 'html5' : 'xhtml';
	}

	$req       = get_option( 'require_name_email' );
	$aria_req  = ( $req ? " aria-required='true'" : '' );
	$html_req  = ( $req ? " required='required'" : '' );
	$html5     = 'html5' === $args['format'];
	$commenter = wp_get_current_commenter();

	$args['label_submit'] = esc_html__( 'Submit comment', 'healthrehub' );

	$args['fields']['author'] = '<p class="comment-form-author"><input id="author" class="comment-form__field" name="author" type="text" placeholder="' . esc_html__( 'enter your name', 'healthrehub' ) . ( $req ? ' *' : '' ) . '" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . $html_req . ' /></p>';

	$args['fields']['email'] = '<p class="comment-form-email"><input id="email" class="comment-form__field" name="email" ' . ( $html5 ? 'type="email"' : 'type="text"' ) . ' placeholder="' . esc_html__( 'enter your email', 'healthrehub' ) . ( $req ? ' *' : '' ) . '" value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30" aria-describedby="email-notes"' . $aria_req . $html_req  . ' /></p>';

	$args['fields']['url'] = '<p class="comment-form-url"><input id="url" class="comment-form__field" name="url" ' . ( $html5 ? 'type="url"' : 'type="text"' ) . ' placeholder="' . esc_html__( 'enter your website', 'healthrehub' ) . '" value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" /></p>';

	$args['comment_field'] = '<p class="comment-form-comment"><textarea id="comment" class="comment-form__field" name="comment" placeholder="' . esc_html__( 'your comment', 'healthrehub' ) . '" cols="45" rows="8" aria-required="true" required="required"></textarea></p>';

	return $args;
}

/**
 * Add extra body classes
 *
 * @param  array $classes Existing classes.
 * @return array
 */
function healthrehub_extra_body_classes( $classes ) {

	// Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	if ( ! healthrehub_is_top_panel_visible() ) {
		$classes[] = 'top-panel-invisible';
	}

	// Adds a class based on header layout type.
	$header_layout = get_theme_mod( 'header_layout_type', healthrehub_theme()->customizer->get_default( 'header_layout_type' ) );
	$classes[] = 'header-layout-' . $header_layout;

	// Adds a options-based classes.
	$header_layout      = get_theme_mod( 'page_layout_type', healthrehub_theme()->customizer->get_default( 'header_container_type' ) );
	$content_layout      = get_theme_mod( 'content_container_type', healthrehub_theme()->customizer->get_default( 'content_container_type' ) );
	$footer_layout      = get_theme_mod( 'footer_container_type', healthrehub_theme()->customizer->get_default( 'footer_container_type' ) );
	$blog_layout = get_theme_mod( 'blog_layout_type', healthrehub_theme()->customizer->get_default( 'blog_layout_type' ) );
	$sb_position = get_theme_mod( 'sidebar_position', healthrehub_theme()->customizer->get_default( 'sidebar_position' ) );
	$sidebar     = get_theme_mod( 'sidebar_width', healthrehub_theme()->customizer->get_default( 'sidebar_width' ) );

	return array_merge( $classes, array(
		'header-layout-' . $header_layout,
		'content-layout-' . $content_layout,
		'footer-layout-' . $footer_layout,
		'blog-' . $blog_layout,
		'position-' . $sb_position,
		'sidebar-' . str_replace( '/', '-', $sidebar ),
	) );
}

/**
 * Replace macroses in text widget.
 *
 * @param  string $text Default text.
 * @return string
 */
function healthrehub_render_widget_macros( $text ) {
	$uploads = wp_upload_dir();

	$data = array(
		'/%%uploads_url%%/' => $uploads['baseurl'],
		'/%%home_url%%/'    => esc_url( home_url( '/' ) ),
		'/%%theme_url%%/'   => get_stylesheet_directory_uri(),
	);

	return preg_replace( array_keys( $data ), array_values( $data ), $text );
}

/**
 * Adds the meta viewport to the header.
 *
 * @since  1.0.1
 * @return string `<meta>` tag for viewport.
 */
function healthrehub_meta_viewport() {
	echo '<meta name="viewport" content="width=device-width, initial-scale=1" />' . "\n";
}

/**
 * Customization for `Tag Cloud` widget.
 *
 * @since  1.0.1
 * @param  array $args Widget arguments.
 * @return array
 */
function healthrehub_customize_tag_cloud( $args ) {
	$args['smallest'] = 14;
	$args['largest']  = 14;
	$args['unit']     = 'px';

	return $args;
}

/**
 * Replaces `[...]` (appended to automatically generated excerpts) with `...`.
 *
 * @since  1.0.1
 * @param  string $more The string shown within the more link.
 * @return string
 */
function healthrehub_excerpt_more( $more ) {

	if ( is_admin() ) {
		return $more;
	}

	return ' &hellip;';
}
