<?php
class Tm_Builder_Module_Link_Box extends Tm_Builder_Module {

	public $function_name;

	public function init() {
		$this->name = esc_html__( 'Link Box', 'healthrehub' );
		$this->slug = 'tm_pb_link_box';
		$this->icon = 'f14c';
		$this->main_css_element = '%%order_class%%.' . $this->slug;

		$this->whitelisted_fields = array(
			'title',
			'image',
			'image_position',
			'button',
			'url',
			'url_new_window',
			'admin_label',
			'module_id',
			'module_class',			
			'use_icon',
			'font_icon',
			'icon_color',			
			'use_icon_font_size',
			'icon_font_size',
			'icon_font_size_tablet',
			'icon_font_size_phone',
		);

		$this->fields_defaults = array(
			'url_new_window'      => array( 'off' ),
			'use_icon'            => array( 'off' ),
			'use_icon_font_size'  => array( 'off' ),
			'image_position'	  => array( 'top' ),
		);
		$this->advanced_options = array(
			'fonts' => array(
				'header' => array(
					'label'    => esc_html__( 'Header', 'healthrehub' ),
					'font_size' => array(
						'default' => '44px',
					),
					'line_height' => array(
						'default' => '1.1em',
					),
					'css'      => array(
						'main' => "{$this->main_css_element} h1, {$this->main_css_element} h1 a",
					),
				),
				'body'   => array(
					'label'    => esc_html__( 'Body', 'healthrehub' ),
					'font_size' => array(
						'default' => '18px',
					),
					'line_height' => array(
						'default' => '1.667em',
					),
					'css'      => array(
						'line_height' => "{$this->main_css_element} p",
					),
				),
			),
			'background' => array(
				'settings' => array(
					'color' => 'alpha',
				),
			),
			'border' => array(),
			'custom_margin_padding' => array(
				'css' => array(
					'important' => 'all',
				),
			),
		);
	}

	public function get_fields() {

		$fields = array(
			'title' => array(
				'label'           => esc_html__( 'Title', 'healthrehub' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'The title of your blurb will appear in bold below your blurb image.', 'healthrehub' ),
			),
			'image' => array(
				'label'              => esc_html__( 'Image', 'healthrehub' ),
				'type'               => 'upload',
				'option_category'    => 'basic_option',
				'upload_button_text' => esc_attr__( 'Upload an image', 'healthrehub' ),
				'choose_text'        => esc_attr__( 'Choose an Image', 'healthrehub' ),
				'update_text'        => esc_attr__( 'Set As Image', 'healthrehub' ),
				'description'        => esc_html__( 'Upload an image to display at the top of your blurb.', 'healthrehub' ),
			),			
			'image_position' => array(
				'label'           => esc_html__( 'Image postion', 'healthrehub' ),
				'type'            => 'select',
				'option_category' => 'configuration',
				'options'         => array(
					'top'   => esc_html__( 'Top', 'healthrehub' ),
					'bottom'  =>  esc_html__( 'Bottom', 'healthrehub' ),
				),
				'description'     => esc_html__( 'Here you can define the order of image', 'healthrehub' ),
			),
			'alt' => array(
				'label'           => esc_html__( 'Image Alt Text', 'healthrehub' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'Define the HTML ALT text for your image here.', 'healthrehub' ),
				'depends_show_if' => 'off',
			),
			'use_icon' => array(
				'label'           => esc_html__( 'Use Icon', 'healthrehub' ),
				'type'            => 'yes_no_button',
				'option_category' => 'basic_option',
				'options'         => array(
					'off' => esc_html__( 'No', 'healthrehub' ),
					'on'  => esc_html__( 'Yes', 'healthrehub' ),
				),
				'affects'     => array(
					'#tm_pb_font_icon',
					'#tm_pb_icon_color',
				),
				'description' => esc_html__( 'Here you can choose whether icon set below should be used.', 'healthrehub' ),
			),
			'font_icon' => array(
				'label'               => esc_html__( 'Icon', 'healthrehub' ),
				'type'                => 'text',
				'option_category'     => 'basic_option',
				'class'               => array( 'tm-pb-font-icon' ),
				'renderer'            => 'tm_pb_get_font_icon_list',
				'renderer_with_field' => true,
				'description'         => esc_html__( 'Choose an icon to display with your blurb.', 'healthrehub' ),
				'depends_default'     => true,
			),
			'icon_color' => array(
				'label'             => esc_html__( 'Icon Color', 'healthrehub' ),
				'type'              => 'color-alpha',
				'description'       => esc_html__( 'Here you can define a custom color for your icon.', 'healthrehub' ),
				'depends_default'   => true,
			),
			'use_icon_font_size' => array(
				'label'           => esc_html__( 'Use Icon Font Size', 'healthrehub' ),
				'type'            => 'yes_no_button',
				'option_category' => 'font_option',
				'options'         => array(
					'off' => esc_html__( 'No', 'healthrehub' ),
					'on'  => esc_html__( 'Yes', 'healthrehub' ),
				),
				'affects'     => array(
					'#tm_pb_icon_font_size',
				),
				'tab_slug' => 'advanced',
			),
			'icon_font_size' => array(
				'label'           => esc_html__( 'Icon Font Size', 'healthrehub' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'tab_slug'        => 'advanced',
				'default'         => '96px',
				'range_settings' => array(
					'min'  => '1',
					'max'  => '120',
					'step' => '1',
				),
				'mobile_options'  => true,
				'depends_default' => true,
			),
			'icon_font_size_tablet' => array(
				'type' => 'skip',
			),
			'icon_font_size_phone' => array(
				'type' => 'skip',
			),
			'button' => array(
				'label'           => esc_html__( 'Button Text', 'healthrehub' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'Input your desired button text.', 'healthrehub' ),
			),
			'url' => array(
				'label'           => esc_html__( 'Url', 'healthrehub' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'If you would like to make your blurb a link, input your destination URL here.', 'healthrehub' ),
			),
			'url_new_window' => array(
				'label'           => esc_html__( 'Url Opens', 'healthrehub' ),
				'type'            => 'select',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'In The Same Window', 'healthrehub' ),
					'on'  => esc_html__( 'In The New Tab', 'healthrehub' ),
				),
				'description' => esc_html__( 'Here you can choose whether or not your link opens in a new window', 'healthrehub' ),
			),
			'content_new' => array(
				'label'             => esc_html__( 'Content', 'healthrehub' ),
				'type'              => 'tiny_mce',
				'option_category'   => 'basic_option',
				'description'       => esc_html__( 'Input the main text content for your module here.', 'healthrehub' ),
			),
			'disabled_on' => array(
				'label'           => esc_html__( 'Disable on', 'healthrehub' ),
				'type'            => 'multiple_checkboxes',
				'options'         => array(
					'phone'   => esc_html__( 'Phone', 'healthrehub' ),
					'tablet'  => esc_html__( 'Tablet', 'healthrehub' ),
					'desktop' => esc_html__( 'Desktop', 'healthrehub' ),
				),
				'additional_att'  => 'disable_on',
				'option_category' => 'configuration',
				'description'     => esc_html__( 'This will disable the module on selected devices', 'healthrehub' ),
			),
			'admin_label' => array(
				'label'       => esc_html__( 'Admin Label', 'healthrehub' ),
				'type'        => 'text',
				'description' => esc_html__( 'This will change the label of the module in the builder for easy identification.', 'healthrehub' ),
			),
			'module_id' => array(
				'label'           => esc_html__( 'CSS ID', 'healthrehub' ),
				'type'            => 'text',
				'option_category' => 'configuration',
				'tab_slug'        => 'custom_css',
				'option_class'    => 'tm_pb_custom_css_regular',
			),
			'module_class' => array(
				'label'           => esc_html__( 'CSS Class', 'healthrehub' ),
				'type'            => 'text',
				'option_category' => 'configuration',
				'tab_slug'        => 'custom_css',
				'option_class'    => 'tm_pb_custom_css_regular',
			),
		);
		return $fields;
	}

	public function shortcode_callback( $atts, $content = null, $function_name ) {

		$this->set_vars(
			array(
				'title',
				'image',
				'image_position',
				'alt',
				'button',
				'url',
				'url_new_window',
				'font_icon',
				'icon',
				'icon_color',	
				'icon_font_size',
				'icon_font_size_tablet',
				'icon_font_size_phone',			
			)
		);

		$this->function_name = $function_name;

		if ( 'off' !== $this->_var( 'use_icon_font_size' ) ) {
			$font_size_values = array(
				'desktop' => $this->_var( 'icon_font_size' ),
				'tablet'  => $this->_var( 'icon_font_size_tablet' ),
				'phone'   => $this->_var( 'icon_font_size_phone' ),
			);

			tm_pb_generate_responsive_css(
				$font_size_values,
				'%%order_class%% .tm-pb-icon',
				'font-size',
				$function_name
			);
		}

		if ( '' !== $this->_var( 'font_icon' ) ) {

			$icon_style = sprintf( 'color: %1$s;', esc_attr( $this->_var( 'icon_color' ) ) );
			$icon        = esc_attr( tm_pb_process_font_icon( $this->_var( 'font_icon' ) ) );
			$icon_family = tm_builder_get_icon_family();

			if ( $icon_family ) {
				TM_Builder_Element::set_style( $function_name, array(
					'selector'    => '%%order_class%% .tm-pb-icon:before',
					'declaration' => sprintf(
						'font-family: "%1$s" !important;',
						esc_attr( $icon_family )
					),
				) );
			}
			$this->_var( 'icon', sprintf(
				'<span class="tm-pb-icon" style="%2$s" data-icon="%1$s"></span>',
				$icon,
				$icon_style
			) );
		}

		
		$this->_var( 'image', sprintf(
			'<div class="tm_pb_main_blurb_image">%1$s</div>',
			( '' !== $this->_var( 'url' )
				? sprintf(
					'<a href="%1$s"%3$s><img src="%2$s" alt="%4$s"></a>',
					tm_builder_tools()->render_url( $this->_var( 'url' ) ),
					esc_url( $this->_var( 'image' ) ),
					( 'on' === $this->_var( 'url_new_window' ) ? ' target="_blank"' : '' ),
					esc_attr( $this->_var( 'alt' ) )
				) : sprintf(
					'<img src="%1$s" alt="%2$s">',
					esc_url( $this->_var( 'image' ) ),
					esc_attr( $this->_var( 'alt' ) )
				)
			)
		) );
		

		if ( '' !== $this->_var( 'title' ) ) {
			$this->_var( 'title', '<h1 class="tm_pb_link_box_title">' . $this->_var( 'title' ) . '</h1>' );
		}

		if ( '' !== $this->_var( 'button' ) && '' !== $this->_var( 'url' ) ) {
			$this->_var( 'button', sprintf(
				'<a class="tm_pb_button" href="%1$s"%3$s>%2$s</a>',
				esc_url( $this->_var( 'url' ) ),
				$this->_var( 'button' ),
				( 'on' === $this->_var( 'url_new_window' ) ? ' target="_blank"' : '' )
			) );
		} else {
			$this->_var( 'button', '' );
		}

		$classes = array();

		$content = $this->get_template_part( 'link_box.php' );

		$output = $this->wrap_module( $content, $classes, $function_name );

		return $output;
	}

}

new Tm_Builder_Module_Link_Box;