<?php
/**
 * Custom functions that act independently of the tm-content-builder plugin.
 *
 * @package HealthRehub
 */

add_action( 'tm_builder_load_user_modules', 'healthrehub_builder_load_user_modules' );

function healthrehub_builder_load_user_modules( $modules_loader ) {

	$modules = array(
		'Tm_Builder_Module_Link_Box' => trailingslashit( HEALTHREHUB_THEME_DIR ) . 'builder/modules/class-builder-module-link-box.php',
		'HealthRehub_Builder_Custom_Module_Slider_Item' => trailingslashit( HEALTHREHUB_THEME_DIR ) . 'builder/modules/class-healthrehub-builder-module-slider-item.php',
	);

	foreach( $modules as $className => $path ) {
		include $path;
		$modules_loader->add_module( $className, $path );
	}
}